﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using Telerik.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VHAReportViewer;

public partial class PatientCompTandOSummary : System.Web.UI.Page
{

    #region Variable Declarations

    List<ReportParameter> _reportParameters = new List<ReportParameter>();
    private UserAccountManager _currentUser;
    string _reportName = "PatientComprehensiveTrendandOutcomeSummaryReport";
    string _facilityChosen = String.Empty;
    string _noteTypesChosen = String.Empty;
    
    #endregion

    #region Protected Methods

    protected void Page_Load(object sender, EventArgs e)
    {
        int _surveyTypeSelectedCount = 0;
        int _noteTypeSelectedCount = 0;
        if (AccessAllowed())
        {
            if (!IsPostBack)
            {
                System.Data.DataTable dataTable = SqlProvider.ExecuteSPDataTable(
                         "RegistryConnectionString", "TBI.usp_GetIOCInstrumentTypes",
                         new object[] { });

                if (dataTable != null)
                {
                    ddlSurveyTypes.DataSource = dataTable;
                    ddlSurveyTypes.DataBind();
                }
               
                System.Data.DataTable dataTable2 = SqlProvider.ExecuteSPDataTable(
                        "RegistryConnectionString", "TBI.usp_GetFiscalYears",
                        new object[] { });

                if (dataTable2 != null)
                {
                    ddlFiscalYears.DataSource = dataTable2;
                    ddlFiscalYears.DataBind();
                    ddlFiscalYears.Items.Add(new ListItem("--Select--", "0"));
                    ddlFiscalYears.SelectedValue = "0";
                }
              
                if (ddlSurveyTypes.Items.Count > 0)
                {
                    foreach (ListItem item in ddlSurveyTypes.Items)
                    {
                        item.Selected = true;
                    }
                }

                DateFrom.Date.Text = "1/1/2012";
                DateTo.Date.Text = DateTime.Now.ToString("MM/dd/yyyy");
             //   lblReportTitle.Visible = false;
            }

            if (Request.QueryString["RunReport"] == "1")
            {
                if (DateFrom.DateValue.Length > 0 && DateTo.DateValue.Length > 0)
                {
                    if (Convert.ToDateTime(DateTo.DateValue) < Convert.ToDateTime(DateFrom.DateValue))
                    {
                        lblDateValidation3.Visible = true;
                        DateFrom.Focus();
                    }
                    else
                    {
                        lblDateValidation3.Visible = false;
                    }
                    //  lblReportTitle.Visible = false;
                    rgFacilityList.Visible = false;
                    rdgrdPatTreatment.Visible = true;
                    btnReturn.Visible = true;
                    //lbl2.Visible = true;
                    if (Request.QueryString["RunReport"] != null)
                    {
                        _facilityChosen = Request.QueryString["FacID"].ToString();
                    }
                    DateTime? _startDate = null;
                    DateTime? _endDate = null;
                    if (DateFrom.DateValue != null)
                    {
                        _startDate = Convert.ToDateTime(DateFrom.DateValue);
                    }
                    if (DateTo.DateValue != null)
                    {
                        _endDate = Convert.ToDateTime(DateTo.DateValue);
                    }
                    string _surveytypelist = String.Empty;
                    string _scoretypelist = String.Empty;
                    string _notetypelist = String.Empty;
                    foreach (ListItem item in ddlSurveyTypes.Items)
                    {
                        if (item.Selected)
                        {
                            _surveytypelist += item.Value + ", ";
                        }
                    }
                    if (_surveytypelist.Length > 0) { _surveytypelist = _surveytypelist.Substring(0, _surveytypelist.Length - 2); }

                    foreach (ListItem item in CheckBoxScoreType.Items)
                    {
                        if (item.Selected)
                        {
                            _scoretypelist += item.Value;
                        }
                    }
                    foreach (ListItem item in CheckBoxNoteStatus.Items)
                    {
                        if (item.Selected)
                        {
                            _notetypelist += item.Value + ", ";
                        }
                    }
                    if (_notetypelist.Length > 0) { _notetypelist = _notetypelist.Substring(0, _notetypelist.Length - 2); }
                    string _fiscalYear = String.Empty;
                    _fiscalYear = ddlFiscalYears.SelectedValue.ToString();
                    if ( _fiscalYear != "0")
                    {
                        _startDate = null;
                        _endDate = null;
                    }
                    // if (sb.ToString().Length > 0) { _notelist = sb.ToString().Substring(0, sb.ToString().Length - 2); }
                    PopulateRdgrdPatTreatmentOnDataSource(_startDate, _endDate, _facilityChosen, _notetypelist, _surveytypelist, _scoretypelist, _fiscalYear);
                }
            }else
            {
                SetReportParameters();
            }
        }
        else
        {
         //   Response.Redirect("ErrorPage.aspx?id=100");
        }
    }

    void Page_PreRender(object sender, EventArgs e)
    {
        if (Session["CTOFromReportFromDate"] != null) { DateFrom.DateValue = Session["CTOFromReportFromDate"].ToString(); }
        if (Session["CTOFromReportToDate"] != null) { DateTo.DateValue = Session["CTOFromReportToDate"].ToString(); }
    }
    protected void btnReturn_Click(object sender, EventArgs e)
    {
        rgFacilityList.Visible = true;
        rdgrdPatTreatment.Visible = false;
        if (Session["CTOFromReportFromDate"] != null) { DateFrom.DateValue = Session["CTOFromReportFromDate"].ToString(); }
        if (Session["CTOFromReportToDate"] != null) { DateTo.DateValue = Session["CTOFromReportToDate"].ToString(); }

        SetReportParameters();

    }
    private void PopulatrgGetFacilitiesOnDataSource(DateTime? startDate, DateTime? endDate, string surveytype, string notetype)
    {
        System.Data.DataTable dataTableGrid = SqlProvider.ExecuteSPDataTable(
                "RegistryConnectionString", "[TBI].[GetComprehesiveFacilityList]",
                new object[] { startDate, endDate, surveytype, notetype });

        if (dataTableGrid != null)
        {
            rgFacilityList.DataSource = dataTableGrid;
            rgFacilityList.DataBind();
        }
        btnReturn.Visible = false;
        //lbl2.Visible = false;
    }
    protected void GridViewOnNeedOfFacilityDataSource(object sender, GridNeedDataSourceEventArgs e)
    {
        //SetReportParameters();
    }
    private void PopulateRdgrdPatTreatment(DateTime? startDate, DateTime? endDate, string facilityid, string notetype)
    {

        //System.Data.DataTable dataTableGrid = SqlProvider.ExecuteSPDataTable(
        //           "RegistryConnectionString", "[TBI].[GetPatientComprehensiveTrendandOutcomeSummary]",
        //           new object[] { startDate, endDate, facilityid, notetype });

        //if (dataTableGrid != null)
        //{
        //    rdgrdPatTreatment.DataSource = dataTableGrid;
        //    rdgrdPatTreatment.DataBind();
        //}
    }

    protected void GridViewOnNeedOfDataSource(object sender, GridNeedDataSourceEventArgs e)
    {
        SetReportParameters();
    }

    private void PopulateRdgrdPatTreatmentOnDataSource(DateTime? startDate, DateTime? endDate, string facilityid, string notetype, string surveytype, string scoretype, string fiscalYear)
    {
        System.Data.DataTable dataTableGrid = SqlProvider.ExecuteSPDataTable(
                "RegistryConnectionString", "[TBI].[GetPatientComprehensiveTrendandOutcomeSummary]",
                new object[] { startDate, endDate, facilityid, notetype, surveytype, scoretype, fiscalYear });

        if (dataTableGrid != null)
        {
            rdgrdPatTreatment.DataSource = dataTableGrid;
            rdgrdPatTreatment.DataBind();
        }
    }

  

    protected void Button1_Click(object sender, EventArgs e)
    {
        if (DateFrom.DateValue.Length == 0 || DateFrom.DateValue == null || DateTo.DateValue.Length == 0 || DateTo.DateValue == null)
        {
            if (DateFrom.DateValue.Length == 0 || DateFrom.DateValue == null)
            {
                lblDateValidation.Visible = true;
                DateFrom.Focus();
            }
            if (DateTo.DateValue.Length == 0 || DateTo.DateValue == null)
            {
                if (IsPostBack)
                {
                    lblDateValidation2.Visible = true;
                    DateTo.Focus();
                }
            }
        }
        else
        {
            if (DateFrom.DateValue.Length > 0 && DateTo.DateValue.Length > 0)
            {
                if (Convert.ToDateTime(DateTo.DateValue) < Convert.ToDateTime(DateFrom.DateValue))
                {
                    lblDateValidation3.Visible = true;
                    DateFrom.Focus();
                }
                else
                {
                    lblDateValidation3.Visible = false;
                }
            }
                Session["CTOFromReportFromDate"] = DateFrom.DateValue.ToString();
            Session["CTOFromReportToDate"] = DateTo.DateValue.ToString();
            Session["CTOFromReportFromDate"] = null;
            Session["CTOFromReportToDate"] = null;
        }
    }

    private void SetReportPath()
    {

    }

    protected void SetReportParameters()
    {
        try
        {
            string userId = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
            string _facilitylist = String.Empty;
            string _notetypelist = String.Empty;
            string _surveytypelist = String.Empty;
            string _scoretypelist = String.Empty;


            if (DateFrom.DateValue.Length == 0 || DateFrom.DateValue == null || DateTo.DateValue.Length == 0 || DateTo.DateValue == null)
            {
                if (DateFrom.DateValue.Length == 0 || DateFrom.DateValue == null)
                {
                    lblDateValidation.Visible = true;
                    DateFrom.Focus();
                }
                if (DateTo.DateValue.Length == 0 || DateTo.DateValue == null)
                {
                    lblDateValidation2.Visible = true;
                    DateTo.Focus();
                }
            }
            else
            {
                //if (DateFrom.DateValue.Length > 0 && DateTo.DateValue.Length > 0)
                //{
                //    if (Convert.ToDateTime(DateTo.DateValue) < Convert.ToDateTime(DateFrom.DateValue))
                //    {
                //        lblDateValidation3.Visible = true;
                //        DateFrom.Focus();
                //    }
                //    else
                //    {
                //        lblDateValidation3.Visible = false;
                //    }
                    lblDateValidation.Visible = false;
                    lblDateValidation2.Visible = false;

                    DateTime? startDate = null;
                    DateTime? endDate = null;


                    if (DateFrom.DateValue != null)
                    {
                        startDate = Convert.ToDateTime(DateFrom.DateValue);
                    }
                    if (DateTo.DateValue != null)
                    {
                        endDate = Convert.ToDateTime(DateTo.DateValue);
                    }

                
                    foreach (ListItem item in CheckBoxNoteStatus.Items)
                    {
                        if (item.Selected)
                        {
                            _notetypelist += item.Value + ", ";
                        }
                    }
                    if (_notetypelist.Length > 0) { _notetypelist = _notetypelist.Substring(0, _notetypelist.Length - 2); }

                    foreach (ListItem item in ddlSurveyTypes.Items)
                    {
                        if (item.Selected)
                        {
                            _surveytypelist += item.Value + ", ";
                        }
                    }
                    if (_surveytypelist.Length > 0) { _surveytypelist = _surveytypelist.Substring(0, _surveytypelist.Length - 2); }

                    foreach (ListItem item in CheckBoxScoreType.Items)
                    {
                        if (item.Selected)
                        {
                            _scoretypelist += item.Value;
                        }
                    }
                   
                    // lblReportTitle.Visible = true;
                    PopulatrgGetFacilitiesOnDataSource(startDate, endDate, _surveytypelist, _notetypelist);
            
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "Get() ReportData");
        }
    }

    protected void DropDownListReportLevel_SelectedIndexChanged(object sender, EventArgs e)
    {
    }

    #endregion

    #region Private Methods

    private void SetDropDownListVisnId()
    {
        
    }

    private void SetDropDownListFacility()
    {
       
    }

    private bool AccessAllowed()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        string myrolename = _currentUser.RoleName.ToString();
        if (myrolename.IndexOf("TBI Rehabilitation and Polytrauma Clinicians") > -1)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    private void SetDropDownListLevel()
    {
        try
        {
           
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "private Fucntion SetDropDownListLevel()");
        }
    }

    private void AddListItem(string itemValue)
    {
        try
        {
          
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "private Function AddListItem()");
        }
    }

    private void EnableDropDownListsVisnAndStation(bool dropDownListVisnIdIsVisible, bool dropDownListFacilityIsVisible)
    {
      
    }

    private void EnableButtonRunReport()
    {
        try
        {
           
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "private Fucntion EnableButtonRunReport()");
        }
    }

    private void DisableReportViewer()
    {
       
    }

    #endregion


    protected void rgFacilityList_ItemDataBound(object sender, GridItemEventArgs e)
    {
        RadAjaxLoadingPanel1.EnableAjaxSkinRendering = true;
    }

    protected void rgFacilityList_PageIndexChanged(object sender, GridPageChangedEventArgs e)
    {
        RadAjaxLoadingPanel1.EnableAjaxSkinRendering = true;
    }

    protected void rdgrdPatTreatment_ItemDataBound(object sender, GridItemEventArgs e)
    {
        RadAjaxLoadingPanel1.EnableAjaxSkinRendering = true;
    }

    protected void rdgrdPatTreatment_PageIndexChanged(object sender, GridPageChangedEventArgs e)
    {
        RadAjaxLoadingPanel1.EnableAjaxSkinRendering = true;
    }
}

